MEMORY
{
/*
    ClaProgPos = 1
    CpuDataPos = 4

    ClaDataSz = 0X800
    ClaProgStart = 0x8800
    ClaProgSz = 0X1800
    CpuDataStart = 0xA000
    CpuDataSz = 0X4000
    CpuProgStart = 0xE000
    CpuProgSz = 0x5FF8
*/
PAGE 0 :  /* Program space */
   /* BEGIN is used for the "boot to SARAM" bootloader mode   */

   BEGIN        : origin = 0x080000, length = 0x000002
   RAMF         : origin = 0x000200, length = 0x000200  /* on-chip RAM block M0 */
 
   RAMPCLA      : origin = 0x8800, length = 0X1800
   RAMPCPU      : origin = 0xE000, length = 0x5FF8	/* All local share memory and RAMGS0 */
   RESET        : origin = 0x3FFFC0, length = 0x000002

   FLASHPROG    : origin = 0x080002, length = 0X8802

PAGE 1 :  /* Data space */

   BOOT_RSVD    : origin = 0x000002, length = 0x0000F3  /* Part of M0, BOOT rom will use this for stack */
   RAMM0        : origin = 0x0000F5, length = 0x00030B	/* Use for stack */
   RAMM1        : origin = 0x000400, length = 0x0003F8  /* on-chip RAM block M1 */

   
   RAMDCLA      : origin = 0x008000, length = 0X800
   RAMDCPU      : origin = 0xA000, length = 0X4000	/* All local share memory and RAMGS0 */

   MSG_CLAtoCPU : origin = 0x001480, length = 0x000080
   MSG_CPUtoCLA : origin = 0x001500, length = 0x000080

   FLASHDATA    : origin = 0X88804, length = 0x010000
}


SECTIONS
{
   /* Allocate program areas: */

   codestart    : > BEGIN        PAGE = 0
   wddisable	: > FLASHPROG,   PAGE = 0
   copysections : > FLASHPROG,   PAGE = 0

   .cinit       : LOAD = FLASHDATA,
                         RUN = RAMDCPU,
                         LOAD_START(_CinitLoadStart),
                         LOAD_SIZE(_CinitSize),
                         RUN_START(_CinitRunStart),
                         PAGE = 1
   .pinit       : LOAD = FLASHDATA,
                         RUN = RAMDCPU,
                         LOAD_START(_PinitLoadStart),
                         LOAD_SIZE(_PinitSize),
                         RUN_START(_PinitRunStart),
                         PAGE = 1
   .switch      : LOAD = FLASHDATA,
                         RUN = RAMDCPU,
                         LOAD_START(_SwitchLoadStart),
                         LOAD_SIZE(_SwitchSize),
                         RUN_START(_SwitchRunStart),
                         PAGE = 1
   .econst      : LOAD = FLASHDATA,
                         RUN = RAMDCPU,
                         LOAD_START(_EconstLoadStart),
                         LOAD_SIZE(_EconstSize),
                         RUN_START(_EconstRunStart),
                         PAGE = 1
   .text        : LOAD = FLASHPROG,
                         RUN = RAMPCPU,
                         LOAD_START(_TextLoadStart),
                         LOAD_SIZE(_TextSize),
                         RUN_START(_TextRunStart),
                         PAGE = 0

   /* Allocate uninitalized data sections: */
   .stack       : > RAMM0,          PAGE = 1
   .ebss        : >>RAMM1 | RAMDCPU,PAGE = 1
   .esysmem     : >>RAMM1 | RAMDCPU,PAGE = 1
   .cio		    : >>RAMM1 | RAMDCPU,PAGE = 1

   .reset       : > RESET,          PAGE = 0, TYPE = DSECT /* not used, */

   .TI.ramfunc  :   LOAD = FLASHPROG,
                         RUN = RAMF,
                         LOAD_START(_RamfuncsLoadStart),
                         LOAD_SIZE(_RamfuncsSize),
                         RUN_START(_RamfuncsRunStart),
                         PAGE = 0  

   Cla1Prog         : LOAD = FLASHPROG,
                         RUN = RAMPCLA,
                         LOAD_START(_Cla1ProgLoadStart),
                         LOAD_SIZE(_Cla1ProgSize),
                         RUN_START(_Cla1ProgRunStart),
                         PAGE = 0

   .scratchpad      : > RAMDCLA,          PAGE = 1
   .bss_cla         : > RAMDCLA,          PAGE = 1
   .const_cla       : LOAD = FLASHDATA,
                         RUN = RAMDCLA,
                         LOAD_START(_Cla1ConstLoadStart),
                         LOAD_SIZE(_Cla1ConstLoadSize),
                         RUN_START(_Cla1ConstRunStart),
                         PAGE = 1

   ClaToCpuMsg      : > MSG_CLAtoCPU,     PAGE = 1
   CpuToClaMsg      : > MSG_CPUtoCLA,     PAGE = 1
}

/*
//===========================================================================
// End of file.
//===========================================================================
*/
